#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// peacock efectMod01.fsh  by   minghir  
//https://www.shadertoy.com/view/mdjXRR
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const float PI = 3.1416;
mat2 rotationMatrix(float angle){
	angle *= PI / 180.0;
    float s=sin(angle), c=cos(angle);
    return mat2( c, -s, s, c );
}
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = (fragCoord-.5*iResolution.xy)/iResolution.y;
    uv *= rotationMatrix(cos(iTime)*sin(iTime))*10.;
    uv *= rotationMatrix(iTime*10.);
    uv += cos(sin(iTime));
    vec2 uv2 = uv;
    uv /= vec2(uv.y*2. , 3. ) / uv.x*1.2 ;  
    uv.y +=(sin(iTime/2.)*cos(iTime/2.));
    uv.x +=cos(sin(iTime/2.))*sin(iTime)*cos(iTime);
    uv = fract(uv)-0.5;
    uv *= vec2(uv.x*2., 2. );  
    float d = (length(uv)-0.5)*((((1.-cos(iTime/5.)*sin(iTime/5.)))));
    d *= length(uv/sin(atan(uv2.x/uv2.y,3.)));
    d = smoothstep(0.,29.*3./iResolution.y,d*d);
    d -= smoothstep(0.,20.*3./iResolution.y,d*d);
    d *= pow(abs(uv2.x),2.); 
   vec3 col = vec3(uv.x-uv.y*d*d);
   col += vec3(d*6.);
   
   col *= mix( vec3(0.2*cos(iTime/2.),0.2*sin(iTime/2.),.7),
               vec3(.2,0.2*sin(iTime/2.),0.7*cos(iTime/2.)),
                3.*(1.-d))+uv.x*uv.y;
   // Output to screen        
   fragColor = vec4(col,1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

